using System;
using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.VBECS.VistaLinkServer.Core
{
    /// <summary>
	/// This exception is thrown if client for some reason is not authorized to 
	/// perform remote procedure call on listener.
	/// </summary>
	public class CallerNotAuthorizedSecurityException : VistALinkException
	{
		/// <summary>
		/// Initializes a new instance of <see cref="CallerNotAuthorizedSecurityException"/> class.
		/// </summary>
		public CallerNotAuthorizedSecurityException() 
			: base( SR.Exceptions.ClientIsNotAuthorizedSecurityExceptionDefaultMessage() ) {}

		/// <summary>
		/// Initializes a new instance of <see cref="CallerNotAuthorizedSecurityException"/> 
		/// class with a specified error message.
		/// </summary>
		/// <param name="message">The message that describes the error.</param>
		public CallerNotAuthorizedSecurityException( string message ) 
			: base( message ) {}

		/// <summary>
		/// Initializes a new instance of the <see cref="CallerNotAuthorizedSecurityException"/> class 
		/// with a specified error message and a reference to the inner 
		/// exception that is the cause of this exception.
		/// </summary>
		/// <param name="message">The message that describes the error.</param>
		/// <param name="innerException">The exception that is the cause of the current exception.</param>
		public CallerNotAuthorizedSecurityException( string message, Exception innerException ) 
			: base( message, innerException ) {}
	}
}
